BEGIN TRAN

ALTER TABLE Proveedores		DROP CONSTRAINT FK_PROVE_Tab_Localidades
ALTER TABLE Empleados_Dom	DROP CONSTRAINT FK_EDOM_Tab_Localidades
ALTER TABLE Empresas_Suc	DROP CONSTRAINT FK_SUC_Tab_Localidades
ALTER TABLE Tab_Calles		DROP CONSTRAINT FK_Cal_Tab_Localidades
ALTER TABLE Dep_Fisicos		DROP CONSTRAINT FK_DEPFIS_Tab_Localidades
ALTER TABLE Empresas_Sedes	DROP CONSTRAINT FK_ESE_Tab_Localidades
ALTER TABLE Clientes		DROP CONSTRAINT FK_CLI_Tab_Localidades
ALTER TABLE Cbtes			DROP CONSTRAINT FK_CBT_Tab_Localidades
ALTER TABLE Tab_Localidades	DROP CONSTRAINT PK_LOC_PorPais_Prov_Id

DROP INDEX IX_LOC_PorProvincia_Id			ON Tab_Localidades
DROP INDEX IX_LOC_PorId						ON Tab_Localidades
DROP INDEX IX_LOC_PorDescrip				ON Tab_Localidades
DROP INDEX IX_PROVE_PorProv_Loc_Id			ON Proveedores
DROP INDEX IX_EDOM_PorPaisProvLoc			ON Empleados_Dom
DROP INDEX IX_SUC_PorPais_Prov_Loc_Suc		ON Empresas_Suc
DROP INDEX IX_Cal_PorLoc					ON Tab_Calles
DROP INDEX IX_Cal_PorDescrip				ON Tab_Calles
DROP INDEX IX_DEPFIS_PorPais				ON Dep_Fisicos
DROP INDEX IX_ESE_PorPais_Prov_Loc_Suc		ON Empresas_Sedes
DROP INDEX IX_CLI_PorPais_Prov_Loc_Id		ON Clientes
DROP INDEX IX_CLI_PorLocCob					ON Clientes
DROP INDEX IX_CBT_PorPais_Prov_Loc_Id		ON Cbtes


ALTER TABLE Tab_Localidades		ALTER COLUMN Id_Localidad		INT NOT NULL
ALTER TABLE Proveedores			ALTER COLUMN Id_Localidad		INT
ALTER TABLE Empleados_Dom		ALTER COLUMN Id_Localidad		INT
ALTER TABLE Empresas_Suc		ALTER COLUMN Id_Localidad		INT
ALTER TABLE Tab_Calles			ALTER COLUMN Id_Localidad		INT
ALTER TABLE Dep_Fisicos			ALTER COLUMN Id_Localidad		INT
ALTER TABLE Empresas_Sedes		ALTER COLUMN Id_Localidad		INT
ALTER TABLE Clientes			ALTER COLUMN Id_Localidad		INT
ALTER TABLE Clientes			ALTER COLUMN Id_Localidad_Cob	INT
ALTER TABLE Cbtes				ALTER COLUMN Id_Localidad		INT



ALTER TABLE Tab_Localidades WITH NOCHECK  ADD  CONSTRAINT PK_LOC_PorPais_Prov_Id PRIMARY KEY CLUSTERED (Id_Pais,	Id_Provincia,	Id_Localidad	)
CREATE NONCLUSTERED INDEX IX_LOC_PorProvincia_Id	ON Tab_Localidades (Id_Provincia, 	Id_Localidad												)
CREATE NONCLUSTERED INDEX IX_LOC_PorId				ON Tab_Localidades (Id_Localidad																)
CREATE NONCLUSTERED INDEX IX_LOC_PorDescrip			ON Tab_Localidades (Descripcion,	Id_Pais,	Id_Provincia,	Id_Localidad					)

ALTER TABLE Proveedores		WITH NOCHECK ADD  CONSTRAINT FK_PROVE_Tab_Localidades	FOREIGN KEY(Id_Pais, Id_Provincia, Id_Localidad)
	REFERENCES Tab_Localidades (Id_Pais, Id_Provincia, Id_Localidad)
ALTER TABLE Empleados_Dom	WITH NOCHECK ADD  CONSTRAINT FK_EDOM_Tab_Localidades	FOREIGN KEY(Id_Pais, Id_Provincia, Id_Localidad)
	REFERENCES Tab_Localidades (Id_Pais, Id_Provincia, Id_Localidad)
ALTER TABLE Empresas_Suc	WITH NOCHECK ADD  CONSTRAINT FK_SUC_Tab_Localidades	FOREIGN KEY(Id_Pais, Id_Provincia, Id_Localidad)
	REFERENCES Tab_Localidades (Id_Pais, Id_Provincia, Id_Localidad)
ALTER TABLE Tab_Calles		WITH NOCHECK ADD  CONSTRAINT FK_Cal_Tab_Localidades		FOREIGN KEY(Id_Pais, Id_Provincia, Id_Localidad)
	REFERENCES Tab_Localidades (Id_Pais, Id_Provincia, Id_Localidad)
ALTER TABLE Dep_Fisicos		WITH NOCHECK ADD  CONSTRAINT FK_DEPFIS_Tab_Localidades	FOREIGN KEY(Id_Pais, Id_Provincia, Id_Localidad)
	REFERENCES Tab_Localidades (Id_Pais, Id_Provincia, Id_Localidad)
ALTER TABLE Empresas_Sedes  WITH NOCHECK ADD  CONSTRAINT FK_ESE_Tab_Localidades		FOREIGN KEY(Id_Pais, Id_Provincia, Id_Localidad)
	REFERENCES Tab_Localidades (Id_Pais, Id_Provincia, Id_Localidad)
ALTER TABLE Clientes		WITH NOCHECK ADD  CONSTRAINT FK_CLI_Tab_Localidades		FOREIGN KEY(Id_Pais, Id_Provincia, Id_Localidad)
	REFERENCES Tab_Localidades (Id_Pais, Id_Provincia, Id_Localidad)
ALTER TABLE Cbtes			WITH NOCHECK ADD  CONSTRAINT FK_CBT_Tab_Localidades		FOREIGN KEY(Id_Pais, Id_Provincia, Id_Localidad)
	REFERENCES Tab_Localidades (Id_Pais, Id_Provincia, Id_Localidad)



CREATE NONCLUSTERED INDEX IX_PROVE_PorProv_Loc_Id			ON Proveedores		(	Id_Pais, 	Id_Provincia, 	Id_Localidad, 	Id_Proveedor				)
CREATE NONCLUSTERED INDEX IX_EDOM_PorPaisProvLoc			ON Empleados_Dom	(	Id_Pais, 	Id_Provincia, 	Id_Localidad, 	Id_Empleado, 	Renglon_Nro )
CREATE NONCLUSTERED INDEX IX_SUC_PorPais_Prov_Loc_Suc		ON Empresas_Suc		(	Id_Pais, 	Id_Provincia, 	Id_Localidad, 	Sucursal_Nro				)
CREATE NONCLUSTERED INDEX IX_Cal_PorLoc						ON Tab_Calles		(	Id_Pais, 	Id_Provincia, 	Id_Localidad, 	Id_Calle					)
CREATE NONCLUSTERED INDEX IX_Cal_PorDescrip					ON Tab_Calles		(	Nombre, 	Id_Pais,	 	Id_Provincia, 	Id_Localidad, 	Id_Calle	)
CREATE NONCLUSTERED INDEX IX_DEPFIS_PorPais					ON Dep_Fisicos		(	Id_Pais, 	Id_Provincia, 	Id_Localidad, 	Id_Deposito_Fisico			)
CREATE NONCLUSTERED INDEX IX_ESE_PorPais_Prov_Loc_Suc		ON Empresas_Sedes	(	Id_Pais, 	Id_Provincia, 	Id_Localidad, 	Descripcion					)
CREATE NONCLUSTERED INDEX IX_CLI_PorPais_Prov_Loc_Id		ON Clientes			(	Id_Pais, 	Id_Provincia, 	Id_Localidad, 	Id_Cliente					)
CREATE NONCLUSTERED INDEX IX_CBT_PorPais_Prov_Loc_Id		ON Cbtes			(	Id_Pais, 	Id_Provincia, 	Id_Localidad, 	Id_Trans					)


ALTER TABLE Clientes  WITH NOCHECK ADD  CONSTRAINT FK_CLI_Tab_Localidades_Cob FOREIGN KEY(Id_Pais_Cob, Id_Provincia_Cob, Id_Localidad_Cob)
	REFERENCES Tab_Localidades (Id_Pais, Id_Provincia, Id_Localidad)
CREATE NONCLUSTERED INDEX IX_CLI_PorPais_Prov_Loc_Id_Cob	ON Clientes (	Id_Pais_Cob,	Id_Provincia_Cob,	Id_Localidad_Cob,	Id_Cliente					)
CREATE NONCLUSTERED INDEX IX_CLI_PorLocCob					ON Clientes (	Id_Pais_Cob, 	Id_Provincia_Cob, 	Id_Localidad_Cob, 	Razon_Social, 	Id_Cliente	)


COMMIT

